<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package xotric
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <?php if (is_singular() && pings_open(get_queried_object())) : ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php wp_body_open(); ?>


    <?php
    $xotric_preloader = get_theme_mod('xotric_preloader', false);
    $xotric_backtotop = get_theme_mod('xotric_backtotop', false);

    $xotric_header_style = function_exists('get_field') ? get_field('header_style') : NULL;
    $xotric_default_header_style = get_theme_mod('choose_default_header', 'header-style-1');

    if ($xotric_header_style == 'header-style-2' && empty($_GET['s'])) {
        $scroll_top_class = $xotric_header_style ? 'scroll-top scroll-top-two' : 'scroll-top';
        $preloader_class = $xotric_header_style ? 'preloader-two' : 'preloader-bg';
    }
    elseif ($xotric_header_style == 'header-style-3' && empty($_GET['s'])) {
        $scroll_top_class = $xotric_header_style ? 'scroll-top scroll-top-three' : 'scroll-top';
        $preloader_class = $xotric_header_style ? 'preloader-three' : 'preloader-bg';
    }
    else {
        if ($xotric_default_header_style == 'header-style-2') {
            $scroll_top_class = $xotric_default_header_style ? 'scroll-top scroll-top-two' : 'scroll-top';
            $preloader_class = $xotric_header_style ? 'preloader-two' : 'preloader-bg';
        }
        elseif ($xotric_default_header_style == 'header-style-3') {
            $scroll_top_class = $xotric_default_header_style ? 'scroll-top scroll-top-three' : 'scroll-top';
            $preloader_class = $xotric_header_style ? 'preloader-three' : 'preloader-bg';
        }
        else {
            $scroll_top_class = $xotric_default_header_style ? 'scroll-top' : '';
            $preloader_class = $xotric_header_style ? 'preloader-bg' : '';
        }
    }
    ?>


    <?php if (!empty($xotric_preloader)) : ?>
        <!-- Preloader -->
        <div id="preloader" class="<?php echo esc_attr($preloader_class); ?>">
            <div id="loading-center">
                <div class="loader">
                    <div class="loader-outter"></div>
                    <div class="loader-inner"></div>
                </div>
            </div>
        </div>
        <!-- Preloader -->
    <?php endif; ?>


    <?php if (!empty($xotric_backtotop)) : ?>
        <!-- Scroll-top -->
        <button class="scroll-top scroll-to-target <?php echo esc_attr($scroll_top_class); ?>" data-target="html">
            <i class="fas fa-angle-up"></i>
        </button>
        <!-- Scroll-top-end-->
    <?php endif; ?>


    <?php do_action('xotric_header_style'); ?>


    <!-- main-area -->
    <main class="main-area">

        <?php do_action('xotric_before_main_content'); ?>