<?php
/**
 * xotric customizer
 *
 * @package xotric
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function xotric_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'xotric_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'Xotric Customizer', 'xotric' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'xotric_default_setting', [
        'title'       => esc_html__( 'Xotric Default Setting', 'xotric' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section('section_header_logo', [
        'title'       => esc_html__('Header Setting', 'xotric'),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ]);

    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Top Setting', 'xotric' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'header_info_setting', [
        'title'       => esc_html__( 'Header Right Setting', 'xotric' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'offcanvas_setting', [
        'title'       => esc_html__( 'Offcanvas Setting', 'xotric' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'mobile_menu_setting', [
        'title'       => esc_html__( 'Mobile Menu Setting', 'xotric' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'xotric' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'xotric' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'xotric' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'xotric' ),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'xotric' ),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'xotric' ),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );

    $wp_customize->add_section( 'slug_setting', [
        'title'       => esc_html__( 'Slug Settings', 'xotric' ),
        'description' => '',
        'priority'    => 22,
        'capability'  => 'edit_theme_options',
        'panel'       => 'xotric_customizer',
    ] );
}

add_action( 'customize_register', 'xotric_customizer_panels_sections' );


/*
Theme Default Settings
*/
function _xotric_default_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_preloader',
        'label'    => esc_html__( 'Preloader ON/OFF', 'xotric' ),
        'section'  => 'xotric_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_backtotop',
        'label'    => esc_html__( 'Back to Top ON/OFF', 'xotric' ),
        'section'  => 'xotric_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_xotric_default_fields' );


/*
Header Settings
 */
function _header_header_fields( $fields ) {

    // Sticky Header
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_sticky_header',
        'label'    => esc_html__( 'Show Sticky Header', 'xotric' ),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Select Header Style', 'xotric' ),
        'section'     => 'section_header_logo',
        'placeholder' => esc_html__( 'Select an option...', 'xotric' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
            'header-style-3' => get_template_directory_uri() . '/inc/img/header/header-3.png',
            'header-style-4' => get_template_directory_uri() . '/inc/img/header/header-4.png',
            'header-style-5' => get_template_directory_uri() . '/inc/img/header/header-5.png',
            'header-style-6' => get_template_directory_uri() . '/inc/img/header/header-6.png',
        ],
        'default'     => 'header-style-1',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Default Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_two',
        'label'       => esc_html__( 'Header Two Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/second_logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_three',
        'label'       => esc_html__( 'Header Three Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/third_logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_four',
        'label'       => esc_html__( 'Header Three Sticky Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/black_logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_five',
        'label'       => esc_html__( 'Header Four Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/fourth_logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_six',
        'label'       => esc_html__( 'Header Five Logo', 'xotric' ),
        'description' => esc_html__( 'Upload Your Logo', 'xotric' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/fifth_logo.svg',
    ];

    $fields[] = [
        'type'        => 'dimension',
        'settings'    => 'logo_size_adjust',
		'label'       => esc_html__( 'Logo Size Height', 'xotric' ),
		'description' => esc_html__( 'Adjust your logo size with px', 'xotric' ),
		'section'     => 'section_header_logo',
		'default'     => '36px',
        'choices'     => [
			'accept_unitless' => true,
		],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );


/*
Header Right Settings
*/
function _header_right_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_header_right',
        'label'    => esc_html__('Show Header Right', 'xotric'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_header_search',
        'label'    => esc_html__('Show Header Search', 'xotric'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_search_title',
        'label'    => esc_html__('Enter Search Title', 'xotric'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_header_search',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('... Search Here ...', 'xotric'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_header_button',
        'label'    => esc_html__('Show Header Button', 'xotric'),
        'section'  => 'header_info_setting',
        'description' => esc_html__('Header Button showing Header Style 2 & 3', 'xotric'),
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_header_btn_text',
        'label'    => esc_html__('Enter Button Text', 'xotric'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Get Started', 'xotric'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_header_btn_url',
        'label'    => esc_html__('Enter Button URL', 'xotric'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'xotric'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_right_fields' );


/*
Offcanvas Settings
*/
function _header_offcanvas_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_offcanvas',
        'label'    => esc_html__('Show Offcanvas', 'xotric'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_address_title',
        'label'    => esc_html__('Enter Address Title', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Office Address', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_address_text',
        'label'    => esc_html__('Enter Address Text', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('123/A, Miranda City Likaoli Prikano, Dope', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_phone_title',
        'label'    => esc_html__('Enter Phone Title', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Phone Number', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_phone_text',
        'label'    => esc_html__('Enter Phone Text', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('+0989 7876 9865 9', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_email_title',
        'label'    => esc_html__('Enter Email Title', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Email Address', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_email_text',
        'label'    => esc_html__('Enter Phone Text', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('info@example.com', 'xotric'),
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_offcanvas_social',
        'label'    => esc_html__('Show Offcanvas Social', 'xotric'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_fb',
        'label'    => esc_html__('Enter Facebook url', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'xotric'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_twitter',
        'label'    => esc_html__('Enter Twitter url', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'xotric'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_instagram',
        'label'    => esc_html__('Enter Instagram url', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'xotric'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_pinterest',
        'label'    => esc_html__('Enter Pinterest url', 'xotric'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'xotric_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'xotric'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_offcanvas_fields' );



/*
Mobile Menu Settings
*/
function _mobile_menu_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_mobile_social',
        'label'    => esc_html__( 'Show Mobile Menu Social', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    // Mobile section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_mobile_fb_url',
        'label'    => esc_html__( 'Facebook URL', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'xotric' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_mobile_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'xotric' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_mobile_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'xotric' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_mobile_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'xotric' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_mobile_telegram_url',
        'label'    => esc_html__( 'Telegram URL', 'xotric' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'xotric' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'xotric_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_mobile_menu_fields' );


/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_hide_default',
        'label'    => esc_html__( 'Breadcrumb Hide by Default', 'xotric' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_info_switch',
        'label'    => esc_html__('Breadcrumb Nav Hide', 'xotric'),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_shape_hide',
        'label'    => esc_html__('Breadcrumb Shape Hide', 'xotric'),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'xotric'),
            'off' => esc_html__('Disable', 'xotric'),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape_one',
        'label'       => esc_html__('Breadcrumb Shape One', 'xotric'),
        'description' => esc_html__('Upload Your Shape', 'xotric'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/images/breadcrumb_shape01.png',
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_shape_hide',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape_two',
        'label'       => esc_html__('Breadcrumb Shape Two', 'xotric'),
        'description' => esc_html__('Upload Your Shape', 'xotric'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/images/breadcrumb_shape02.png',
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_shape_hide',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_blog_btn_switch',
        'label'    => esc_html__( 'Blog Button ON/OFF', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_blog_cat',
        'label'    => esc_html__( 'Blog Category Meta ON/OFF', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_blog_author',
        'label'    => esc_html__( 'Blog Author Meta ON/OFF', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_blog_date',
        'label'    => esc_html__( 'Blog Date Meta ON/OFF', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_blog_comments',
        'label'    => esc_html__( 'Blog Comments Meta ON/OFF', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'xotric_show_blog_share',
        'label'    => esc_html__( 'Show Blog Share', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'xotric' ),
            'off' => esc_html__( 'Disable', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'xotric' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'xotric' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'xotric' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'xotric' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'xotric' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'xotric' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
        ],
        'default'     => 'footer-style-1',
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'xotric' ),
        'section'     => 'footer_setting',
        'default'     => '4',
        'placeholder' => esc_html__( 'Select an option...', 'xotric' ),
        'priority'    => 11,
        'multiple'    => 1,
        'choices'     => [
            '4' => esc_html__( 'Widget Number 4', 'xotric' ),
            '3' => esc_html__( 'Widget Number 3', 'xotric' ),
            '2' => esc_html__( 'Widget Number 2', 'xotric' ),
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'xotric' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'xotric' ),
        'section'     => 'footer_setting',
        'default'     => '#080c35',
        'priority'    => 12,
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'xotric_copyright',
        'label'    => esc_html__( 'CopyRight', 'xotric' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Copyright © Xotric 2023. All Rights Reserved', 'xotric' ),
        'priority' => 15,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function xotric_color_fields( $fields ) {

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option',
        'label'       => __( 'Primary Color', 'xotric' ),
        'description' => esc_html__('This is a Primary color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#7E54F8',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option2',
        'label'       => __('Secondary Color', 'xotric' ),
        'description' => esc_html__('This is a Secondary color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#F85454',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option3',
        'label'       => __('Third Color', 'xotric' ),
        'description' => esc_html__('This is a Third color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#FFC42B',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option4',
        'label'       => __('Fourth Color', 'xotric' ),
        'description' => esc_html__('This is Fourth color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#5956E9',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option5',
        'label'       => __('Fifth Color', 'xotric' ),
        'description' => esc_html__('This is Fifth color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#F07707',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option6',
        'label'       => __('Green Color', 'xotric' ),
        'description' => esc_html__('This is Green color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#348A63',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'xotric_color_option7',
        'label'       => __('Red Color', 'xotric' ),
        'description' => esc_html__('This is Red color control.', 'xotric' ),
        'section'     => 'color_setting',
        'default'     => '#F22556',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'xotric_color_fields' );

// 404
function xotric_404_fields( $fields ) {

    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_error_text',
        'label'    => esc_html__('404 Text', 'xotric'),
        'section'  => '404_page',
        'default'  => esc_html__('404', 'xotric'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'xotric_error_title',
        'label'    => esc_html__( 'Not Found Title', 'xotric' ),
        'section'  => '404_page',
        'default'  => esc_html__('Sorry, the page you are looking for could not be found', 'xotric' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'xotric' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'xotric' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'xotric_404_fields' );


/**
 * Added Fields
 */
function xotric_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading h1 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h2_setting',
        'label'       => esc_html__( 'Heading h2 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h2',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h3_setting',
        'label'       => esc_html__( 'Heading h3 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h3',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h4_setting',
        'label'       => esc_html__( 'Heading h4 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h4',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h5_setting',
        'label'       => esc_html__( 'Heading h5 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h5',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h6_setting',
        'label'       => esc_html__( 'Heading h6 Fonts', 'xotric' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h6',
            ],
        ],
    ];
    return $fields;
}

add_filter( 'kirki/fields', 'xotric_typo_fields' );


/**
 * Added Fields
 */
function xotric_slug_setting( $fields ) {
    // slug settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_ev_slug',
        'label'    => esc_html__( 'Event Slug', 'xotric' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__( 'ourevent', 'xotric' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'xotric_port_slug',
        'label'    => esc_html__( 'Portfolio Slug', 'xotric' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__( 'ourportfolio', 'xotric' ),
        'priority' => 10,
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'xotric_slug_setting' );


/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function XOTRIC_THEME_OPTION( $name ) {
    $value = '';
    if ( class_exists( 'xotric' ) ) {
        $value = Kirki::get_option( xotric_get_theme(), $name );
    }

    return apply_filters('XOTRIC_THEME_OPTION', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function xotric_get_theme() {
    return 'xotric';
}