<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xotric
 */

$xotric_audio_url = function_exists('get_field') ? get_field('fromate_style') : NULL;
$xotric_show_blog_share = get_theme_mod('xotric_show_blog_share', false);
$xotric_post_tags_width = $xotric_show_blog_share ? 'col-md-7' : 'col-12';

?>

<?php if (is_single()) : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('blog-item blog-details-wrap format-audio'); ?>>

        <?php if (!empty($xotric_audio_url)) : ?>
            <div class="blog-thumb postbox__audio ratio ratio-16x9">
                <?php echo wp_oembed_get($xotric_audio_url); ?>
            </div>
        <?php endif; ?>

        <div class="blog-details-content">

            <!-- blog meta -->
            <div class="blog-meta">
                <?php get_template_part('template-parts/blog/blog-meta'); ?>
            </div>

            <div class="post-text">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'xotric'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>

            <?php if (!empty(get_the_tags())) : ?>
                <div class="blog-details-bottom">

                    <div class="row">
                        <div class="<?php echo esc_attr($xotric_post_tags_width); ?>">
                            <?php print xotric_get_tag(); ?>
                        </div>
                        <?php if (!empty($xotric_show_blog_share)) : ?>
                            <div class="col-md-5">
                                <div class="blog-details-social text-md-end">
                                    <?php xotric_social_share(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            <?php endif; ?>

        </div>
    </article>

<?php else : ?>



    <article id="post-<?php the_ID(); ?>" <?php post_class('blog-item format-audio'); ?>>

        <?php if (!empty($xotric_audio_url)) : ?>
            <div class="blog-thumb postbox__audio ratio ratio-16x9">
                <?php echo wp_oembed_get($xotric_audio_url); ?>
            </div>
        <?php endif; ?>

        <div class="blog-content">

            <!-- blog meta -->
            <div class="blog-meta">
                <?php get_template_part('template-parts/blog/blog-meta'); ?>
            </div>
            <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <div class="post-text">
                <p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), 60, ''); ?></p>
            </div>
            <!-- blog btn -->
            <?php get_template_part('template-parts/blog/blog-btn'); ?>

        </div>

    </article>


<?php endif; ?>