<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xotric
 */

// Header Settings
$xotric_show_sticky_header = get_theme_mod('xotric_show_sticky_header', false);
$sticky_header = $xotric_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $xotric_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'xotric-menu-has-showing' : 'xotric-menu-not-showing';

// Header Right
$xotric_show_header_right = get_theme_mod('xotric_show_header_right', false);

// Header Search
$xotric_show_header_search = get_theme_mod('xotric_show_header_search', false);
$xotric_search_title = get_theme_mod('xotric_search_title', __('... Search Here ...', 'xotric'));

// Offcanvas Menu
$xotric_show_offcanvas = get_theme_mod('xotric_show_offcanvas', false);
$offcanvas_address_title = get_theme_mod('offcanvas_address_title', __('Office Address', 'xotric'));
$offcanvas_address_text = get_theme_mod('offcanvas_address_text', __('123/A, Miranda City Likaoli
Prikano, Dope', 'xotric'));
$offcanvas_phone_title = get_theme_mod('offcanvas_phone_title', __('Phone Number', 'xotric'));
$offcanvas_phone_text = get_theme_mod('offcanvas_phone_text', __('+0989 7876 9865 9', 'xotric'));
$offcanvas_email_title = get_theme_mod('offcanvas_email_title', __('Email Address', 'xotric'));
$offcanvas_email_text = get_theme_mod('offcanvas_email_text', __('info@example.com', 'xotric'));

$xotric_show_offcanvas_social = get_theme_mod('xotric_show_offcanvas_social', false);
$offcanvas_fb = get_theme_mod('offcanvas_fb', __('#', 'xotric'));
$offcanvas_twitter = get_theme_mod('offcanvas_twitter', __('#', 'xotric'));
$offcanvas_instagram = get_theme_mod('offcanvas_instagram', __('#', 'xotric'));
$offcanvas_pinterest = get_theme_mod('offcanvas_pinterest', __('#', 'xotric'));

// Mobile Menu
$xotric_show_mobile_social = get_theme_mod('xotric_show_mobile_social', false);

?>


<!-- header-area -->
<header>
    <div id="header-fixed-height" class="<?php echo esc_attr($sticky_height) ?>"></div>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area <?php echo esc_attr($menu_padding) ?>">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav">
                            <div class="logo">
                                <?php xotric_header_logo(); ?>
                            </div>
                            <div class="navbar-wrap main-menu d-none d-lg-flex">
                                <?php xotric_header_menu(); ?>
                            </div>
                            <?php if (!empty($xotric_show_header_right)) : ?>
                                <div class="header-action">
                                    <ul class="list-wrap">

                                        <?php if (!empty($xotric_show_header_search)) : ?>
                                            <li class="header-search">
                                                <a href="#">
                                                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M11.5 21C16.7467 21 21 16.7467 21 11.5C21 6.25329 16.7467 2 11.5 2C6.25329 2 2 6.25329 2 11.5C2 16.7467 6.25329 21 11.5 21Z" stroke="currentcolor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M22 22L20 20" stroke="currentcolor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if (!empty($xotric_show_offcanvas)) : ?>
                                            <li class="offcanvas-menu">
                                                <a href="#" class="menu-tigger">
                                                    <span></span>
                                                    <span></span>
                                                    <span></span>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                            <?php } ?>
                        </nav>
                    </div>

                    <!-- Mobile Menu  -->
                    <div class="mobile-menu">
                        <nav class="menu-box">
                            <div class="close-btn"><i class="fas fa-times"></i></div>
                            <div class="nav-logo">
                                <?php xotric_header_logo(); ?>
                            </div>
                            <div class="menu-outer">
                                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                            </div>

                            <?php if (!empty($xotric_show_mobile_social)) : ?>
                                <div class="social-links">
                                    <?php xotric_mobile_social_profiles(); ?>
                                </div>
                            <?php endif; ?>

                        </nav>
                    </div>
                    <div class="menu-backdrop"></div>
                    <!-- End Mobile Menu -->

                </div>
            </div>
        </div>
    </div>

    <?php if (!empty($xotric_show_header_search)) : ?>
        <!-- header-search -->
        <div class="search-popup-wrap" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="search-close">
                <span><i class="fas fa-times"></i></span>
            </div>
            <div class="search-wrap text-center">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <?php if (!empty($xotric_search_title)) : ?>
                                <h2 class="title"><?php echo esc_html($xotric_search_title) ?></h2>
                            <?php endif; ?>
                            <div class="search-form">
                                <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                                    <input class="search-input-field" type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Type keywords here', 'xotric'); ?>">
                                    <button class="search-btn"><i class="fas fa-search"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header-search-end -->
    <?php endif; ?>

    <?php if (!empty($xotric_show_offcanvas)) : ?>
        <!-- offCanvas-menu -->
        <div class="extra-info">
            <div class="close-icon menu-close">
                <button><i class="far fa-window-close"></i></button>
            </div>

            <div class="logo-side mb-30">
                <?php xotric_header_logo(); ?>
            </div>

            <div class="side-info mb-30">

                <?php if (!empty($offcanvas_address_text)) : ?>
                    <div class="contact-list mb-30">
                        <h4><?php echo esc_html($offcanvas_address_title) ?></h4>
                        <p><?php echo wp_kses_post($offcanvas_address_text); ?></p>
                    </div>
                <?php endif; ?>

                <?php if (!empty($offcanvas_phone_text)) : ?>
                    <div class="contact-list mb-30">
                        <h4><?php echo esc_html($offcanvas_phone_title) ?></h4>
                        <p><?php echo wp_kses_post($offcanvas_phone_text); ?></p>
                    </div>
                <?php endif; ?>

                <?php if (!empty($offcanvas_email_text)) : ?>
                    <div class="contact-list mb-30">
                        <h4><?php echo esc_html($offcanvas_email_title) ?></h4>
                        <p><?php echo wp_kses_post($offcanvas_email_text); ?></p>
                    </div>
                <?php endif; ?>

            </div>

            <?php if (!empty($xotric_show_offcanvas_social)) : ?>
                <div class="social-icon-right mt-30">

                    <?php if (!empty($offcanvas_fb)) : ?>
                        <a href="<?php echo esc_url($offcanvas_fb); ?>"><i class="fab fa-facebook-f"></i></a>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_twitter)) : ?>
                        <a href="<?php echo esc_url($offcanvas_twitter); ?>"><i class="fab fa-twitter"></i></a>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_instagram)) : ?>
                        <a href="<?php echo esc_url($offcanvas_instagram); ?>"><i class="fab fa-instagram"></i></a>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_pinterest)) : ?>
                        <a href="<?php echo esc_url($offcanvas_pinterest); ?>"><i class="fab fa-pinterest-p"></i></a>
                    <?php endif; ?>

                </div>
            <?php endif; ?>

        </div>
        <div class="offcanvas-overly"></div>
        <!-- offCanvas-menu-end -->
    <?php endif; ?>

</header>
<!-- header-area-end -->