<?php

/**
 * Template part for displaying header layout five
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xotric
 */

// Header Settings
$xotric_show_sticky_header = get_theme_mod('xotric_show_sticky_header', false);
$sticky_header = $xotric_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $xotric_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'xotric-menu-has-showing' : 'xotric-menu-not-showing';

// Header Right
$xotric_show_header_right = get_theme_mod('xotric_show_header_right', false);

// Header Button
$xotric_show_header_button = get_theme_mod('xotric_show_header_button', false);
$xotric_header_btn_text = get_theme_mod('xotric_header_btn_text', __('Get Started', 'xotric'));
$xotric_header_btn_url = get_theme_mod('xotric_header_btn_url', __('#', 'xotric'));

// Mobile Menu
$xotric_show_mobile_social = get_theme_mod('xotric_show_mobile_social', false);

?>


<!-- header-area -->
<header class="home-four-header">
    <div id="header-fixed-height" class="<?php echo esc_attr($sticky_height) ?>"></div>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area transparent-header <?php echo esc_attr($menu_padding) ?>">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav">
                            <div class="logo">
                                <?php xotric_header_four_logo(); ?>
                            </div>
                            <div class="navbar-wrap main-menu d-none d-lg-flex">
                                <?php xotric_header_menu(); ?>
                            </div>
                            <?php if (!empty($xotric_show_header_right)) : ?>
                                <div class="header-action">
                                    <ul class="list-wrap">

                                        <?php if (!empty($xotric_show_header_button)) : ?>
                                            <li class="header-btn">
                                                <a href="<?php echo esc_url($xotric_header_btn_url) ?>" class="btn btn-four"><?php echo esc_html($xotric_header_btn_text); ?> <span></span></a>
                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                            <?php } ?>
                        </nav>
                    </div>

                    <!-- Mobile Menu  -->
                    <div class="mobile-menu">
                        <nav class="menu-box">
                            <div class="close-btn"><i class="fas fa-times"></i></div>
                            <div class="nav-logo">
                                <?php xotric_header_four_logo(); ?>
                            </div>
                            <div class="menu-outer">
                                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                            </div>

                            <?php if (!empty($xotric_show_mobile_social)) : ?>
                                <div class="social-links">
                                    <?php xotric_mobile_social_profiles(); ?>
                                </div>
                            <?php endif; ?>

                        </nav>
                    </div>
                    <div class="menu-backdrop"></div>
                    <!-- End Mobile Menu -->

                </div>
            </div>
        </div>
    </div>

</header>
<!-- header-area-end -->