SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

CREATE TABLE `active_payment` (
  `id` bigint(20) NOT NULL,
  `payment_method` varchar(15) NOT NULL,
  `sender_number` varchar(55) NOT NULL,
  `transaction_id` text NOT NULL,
  `amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `main_balance` decimal(16,2) NOT NULL DEFAULT 0.00,
  `date` datetime DEFAULT NULL,
  `status` enum('Active','Pending','Trash') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `activity_log` (
  `id` bigint(20) NOT NULL,
  `log_data` longtext DEFAULT NULL,
  `date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `addons` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `unique_identifier` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `activated` int(11) NOT NULL,
  `image` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `addons` (`id`, `name`, `unique_identifier`, `version`, `activated`, `image`) VALUES
(1, 'Reseller Club', 'resellerclub', '1.0.0', 0, 'uploads/addons_banner/resellerclub.png'),
(2, 'Reseller Camp', 'resellercamp', '1.0.0', 0, 'uploads/addons_banner/resellercamp.png'),
(3, 'Global Payment', 'global_payment', '1.0.0', 0, 'uploads/addons_banner/global_payment.png'),
(4, 'Role Management', 'role_management', '1.0.0', 0, 'uploads/addons_banner/role_management.png'),
(5, 'SMS Notification', 'sms', '1.0.0', 0, 'uploads/addons_banner/sms.png');


CREATE TABLE `admin` (
  `id` int(11) NOT NULL,
  `full_name` varchar(55) DEFAULT NULL,
  `username` varchar(25) NOT NULL,
  `email` varchar(55) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `picture` varchar(255) DEFAULT NULL,
  `user_role` enum('admin','moderator') NOT NULL DEFAULT 'admin',
  `password` varchar(60) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `custom_login_link` varchar(25) NOT NULL DEFAULT 'login',
  `last_seen` datetime DEFAULT NULL,
  `notification_enabled` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `admin` (`id`, `full_name`, `username`, `email`, `phone`, `picture`, `user_role`, `password`, `token`, `custom_login_link`, `last_seen`, `notification_enabled`) VALUES
(1, 'UddoktaPay', 'admin', 'test@gmail.com', '013********', 'uploads/picture/637b187f155da3-75434815-66939445.png', 'admin', '$2y$10$DsHr1W3maLyPi789D2XeCu.Y.73a9kJ1HuN421M/FgboLmWVvxNkq', '637b9e9c02cd48-26653571-31106204', 'login', '2024-12-31 08:16:22', 0);


CREATE TABLE `brand_settings` (
  `id` int(11) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `logo` text DEFAULT NULL,
  `favicon` text DEFAULT NULL,
  `invoice_logo` text DEFAULT NULL,
  `invoice_banner` text DEFAULT NULL,
  `api_key` varchar(255) NOT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `invoice_api_key` varchar(255) NOT NULL,
  `webhook_api_key` varchar(255) NOT NULL,
  `default_language` varchar(10) NOT NULL DEFAULT 'bangla',
  `allow_pending_payment` tinyint(1) NOT NULL DEFAULT 0,
  `pending_template` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `description` text DEFAULT NULL,
  `fb_og_image` text DEFAULT NULL,
  `twitter_og_image` text DEFAULT NULL,
  `support_number` varchar(25) DEFAULT NULL,
  `whatsapp_number` varchar(25) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `gtm_id` varchar(25) DEFAULT NULL,
  `support_mail` varchar(255) DEFAULT NULL,
  `telegram_id` varchar(255) DEFAULT NULL,
  `support_link` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `brand_settings` (`id`, `url`, `name`, `logo`, `favicon`, `invoice_logo`, `invoice_banner`, `api_key`, `api_secret`, `invoice_api_key`, `webhook_api_key`, `default_language`, `allow_pending_payment`, `pending_template`, `description`, `fb_og_image`, `twitter_og_image`, `support_number`, `whatsapp_number`, `facebook_id`, `gtm_id`, `support_mail`, `telegram_id`, `support_link`, `status`) VALUES
(1, NULL, 'Company Name', NULL, NULL, NULL, NULL, 'f1d5bd54b659a131aad3020f1bbcd15e5bd275d9', NULL, 'cd1edb583f1f236658860652bfe1605304d7d4bc', 'a965483bdc281e951d7c42ecd61f82fd1259ce27', 'bangla', 1, 'Inactive', '', NULL, NULL, '', '', '', '', '', '', '', 'Active');


CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `faq` (
  `id` int(11) NOT NULL,
  `brand_id` varchar(255) NOT NULL DEFAULT '1',
  `english_title` text DEFAULT NULL,
  `bangla_title` text NOT NULL,
  `english_content` longtext DEFAULT NULL,
  `bangla_content` longtext DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `international_methods` (
  `id` int(11) NOT NULL,
  `brand_id` varchar(255) NOT NULL DEFAULT '1',
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `transaction_fee` decimal(16,2) NOT NULL DEFAULT 0.00,
  `min_amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `max_amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `logo` varchar(255) DEFAULT NULL,
  `extra` longtext DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `international_methods` (`id`, `brand_id`, `name`, `type`, `transaction_fee`, `min_amount`, `max_amount`, `logo`, `extra`, `status`) VALUES
(1, '1', 'Paypal', 'paypal', 2.00, 1.00, 10000.00, NULL, '{\"description\":\"Purchasing Goods from {brand_name}, Invoice Id {invoice_id}\",\"sandbox\":\"Off\",\"extra_fee\":\"0.00\"}', 'Inactive'),
(2, '1', 'Paypal Personal', 'paypal-personal', 2.00, 1.00, 10000.00, NULL, '{\"description\":\"Purchasing Goods from {brand_name}, Invoice Id {invoice_id}\",\"sandbox\":\"Off\",\"extra_fee\":\"0.00\"}', 'Inactive'),
(3, '1', 'Paddle', 'paddle', 2.00, 1.00, 10000.00, NULL, '{\"description\":\"Purchasing Goods from {brand_name}, Invoice Id {invoice_id}\",\"account_type\":\"v2\",\"sandbox\":\"Off\"}', 'Inactive'),
(4, '1', 'Stripe', 'stripe', 2.00, 1.00, 10000.00, NULL, '{\"description\":\"Purchasing Goods from {brand_name}, Invoice Id {invoice_id}\",\"sandbox\":\"Off\",\"extra_fee\":\"0.00\"}', 'Inactive'),
(5, '1', 'Perfect Money', 'perfectmoney', 2.00, 1.00, 10000.00, NULL, '{\"description\":\"Purchasing Goods from {brand_name}, Invoice Id {invoice_id}\",\"extra_fee\":\"0.00\"}', 'Inactive'),
(24, '1', 'Payoneer', 'manual', 1.00, 1.00, 10000.00, 'uploads/method_logo/payoneer.png', '{\"english_template\":\"{line_start}\\r\\n{highlight_start}Email:{highlight_end} test@example.com {copy_start}test@example.com{copy_end}\\r\\n{line_end}\\r\\n{line_start}\\r\\n{highlight_start}Amount:{highlight_end} {amount}\\r\\n{line_end}\"}', 'Inactive'),
(25, '1', 'Wise', 'manual', 1.00, 1.00, 10000.00, 'uploads/method_logo/wise.png', '{\"english_template\":\"{line_start}\\r\\n{highlight_start}Email:{highlight_end} test@example.com {copy_start}test@example.com{copy_end}\\r\\n{line_end}\\r\\n{line_start}\\r\\n{highlight_start}Amount:{highlight_end} {amount}\\r\\n{line_end}\"}', 'Inactive'),
(26, '1', 'Binance Personal', 'binance-personal', 2.00, 1.00, 10000.00, NULL, '{\"account_type\":\"Email \\/ Phone\"}', 'Active');


CREATE TABLE `mobile_banking_methods` (
  `id` int(11) NOT NULL,
  `brand_id` varchar(255) NOT NULL DEFAULT '1',
  `name` varchar(255) NOT NULL,
  `live_name` varchar(255) DEFAULT NULL,
  `type` enum('Personal','Merchant','Agent','Live','Bank') NOT NULL,
  `transaction_fee` decimal(16,2) NOT NULL DEFAULT 0.00,
  `number` varchar(15) DEFAULT NULL,
  `min_amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `max_amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `balance_verify` varchar(255) NOT NULL DEFAULT 'Inactive',
  `main_balance` decimal(16,2) NOT NULL DEFAULT 0.00,
  `auto_update_account_balance` varchar(255) NOT NULL DEFAULT 'Inactive',
  `verify_failed` int(11) NOT NULL DEFAULT 0,
  `verify_failed_limit` int(11) NOT NULL DEFAULT 2,
  `qr_code` varchar(255) NOT NULL DEFAULT 'Inactive',
  `qr_code_image` varchar(255) DEFAULT NULL,
  `extra` longtext DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `mobile_banking_methods` (`id`, `brand_id`, `name`, `live_name`, `type`, `transaction_fee`, `number`, `min_amount`, `max_amount`, `balance_verify`, `main_balance`, `auto_update_account_balance`, `verify_failed`, `verify_failed_limit`, `qr_code`, `qr_code_image`, `extra`, `status`) VALUES
(1, '1', 'bKash', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(2, '1', 'bKash', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(3, '1', 'bKash', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 2, 2, 'Inactive', NULL, NULL, 'Inactive'),
(4, '1', 'Rocket', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(5, '1', 'Rocket', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(6, '1', 'Rocket', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(7, '1', 'Nagad', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(8, '1', 'Nagad', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(9, '1', 'Nagad', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(10, '1', 'Upay', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(11, '1', 'Upay', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(12, '1', 'Upay', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(13, '1', 'Cellfin', NULL, 'Personal', 1.90, '013********', 1.00, 100000.00, '', 0.00, '', 0, 0, '', NULL, NULL, 'Inactive'),
(21, '1', 'Tap', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(22, '1', 'Tap', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(23, '1', 'Tap', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(24, '1', 'OkWallet', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(25, '1', 'OkWallet', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(26, '1', 'OkWallet', NULL, 'Agent', 0.00, '013********', 1.00, 100000.00, 'Inactive', 0.00, 'Active', 0, 2, 'Inactive', NULL, NULL, 'Inactive'),
(27, '1', 'Ipay', NULL, 'Personal', 0.00, '013********', 1.00, 100000.00, '', 0.00, '', 0, 0, '', NULL, NULL, 'Inactive'),
(41, '1', 'IBBL', 'IBBL', 'Bank', 0.00, NULL, 1.00, 100.00, 'Inactive', 0.00, 'Inactive', 0, 2, 'Inactive', NULL, '{\"ibbl_sandbox\":\"Off\",\"ibbl_product_name\":\"School Fees\"}', 'Inactive'),
(44, '1', 'Cellfin', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, '', 0.00, '', 0, 0, 'Inactive', 'uploads/qr_code/676ea5874a6279-90054216-55310237.png', NULL, 'Inactive'),
(45, '1', 'Ipay', NULL, 'Merchant', 0.00, '013********', 1.00, 100000.00, '', 0.00, '', 0, 0, 'Inactive', 'Inactive', NULL, 'Inactive');


CREATE TABLE `net_banking_methods` (
  `id` int(11) NOT NULL,
  `brand_id` varchar(255) NOT NULL DEFAULT '1',
  `bank_name` varchar(255) NOT NULL,
  `bank_slug` varchar(15) NOT NULL,
  `bank_logo` text DEFAULT NULL,
  `account_name` varchar(255) NOT NULL,
  `account_number` varchar(55) NOT NULL,
  `branch_name` varchar(255) NOT NULL,
  `routing_number` varchar(55) NOT NULL,
  `swift_code` varchar(255) DEFAULT NULL,
  `min_amount` int(11) DEFAULT NULL,
  `max_amount` int(11) DEFAULT NULL,
  `background_color` varchar(7) DEFAULT NULL,
  `hover_color` varchar(7) DEFAULT NULL,
  `hr_color` varchar(7) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `net_banking_methods` (`id`, `brand_id`, `bank_name`, `bank_slug`, `bank_logo`, `account_name`, `account_number`, `branch_name`, `routing_number`, `swift_code`, `min_amount`, `max_amount`, `background_color`, `hover_color`, `hr_color`, `status`) VALUES
(4, '1', 'Islami Bank Bangladesh', 'ibbl', 'uploads/bank_logo/ibbl.png', 'Name', '123456789', 'Branch', '123456789', NULL, 1, 10000, '#7B1FA2', '#9C27B0', '#E1BEE7', 'Inactive'),
(5, '1', 'Dutch Bangla Bank', 'dbb', 'uploads/bank_logo/dbbl.png', 'Name', '123456789', 'Branch', '123456789', NULL, 1, 10000, '#00796B', '#009688', '#B2DFDB', 'Inactive'),
(6, '1', 'City Bank', 'cb', 'uploads/bank_logo/cbl.png', 'Name', '123456789', 'Branch', '123456789', NULL, 1, 10000, '#D32F2F', '#F44336', '#FFCDD2', 'Inactive'),
(7, '1', 'BRAC Bank', 'bb', 'uploads/bank_logo/bbl.png', 'Name', '123456789', 'Branch', '123456789', NULL, 1, 10000, '#303F9F', '#3F51B5', '#C5CAE9', 'Inactive'),
(8, '1', 'Bank Asia', 'ba', 'uploads/bank_logo/bal.png', 'Name', '123456789', 'Branch', '123456789', NULL, 1, 10000, '#E64A19', '#FF5722', '#FFCCBC', 'Inactive'),
(9, '1', 'Pubali Bank', 'pb', 'uploads/bank_logo/pbl.png', 'Name', '123456789', 'Branch', '123456789', '', 1, 10000, '#388E3C', '#4CAF50', '#212121', 'Inactive');


CREATE TABLE `options` (
  `id` bigint(20) NOT NULL,
  `name` varchar(500) DEFAULT NULL,
  `value` longtext DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO `options` (`id`, `name`, `value`) VALUES
(164, 'up_version', '4.2.1'),
(165, 'last_cron_job_executed', '2024-12-31 09:22:02'),
(166, 'enable_onesignal', '0'),
(167, 'apk_api_key', 'e55d9979c0a8812447c3415a2cd3c0f13def69b7'),
(168, 'template_text_bangla', ''),
(169, 'template_text_english', ''),
(170, 'custom_css', ''),
(171, 'email_method', '0'),
(172, 'from_email_address', 'no-reply@your-domain.com'),
(173, 'smtp_connection_type', '1'),
(174, 'smtp_authentication', '1'),
(175, 'smtp_host', 'sandbox.smtp.mailtrap.io'),
(176, 'smtp_port', '2525'),
(177, 'smtp_username', '2a9847fdaac1ca'),
(178, 'smtp_password', 'd86261b451622a'),
(179, 'onesignal_app_id', ''),
(180, 'onesignal_api_key', ''),
(181, 'onesignal_complete_payment', '0'),
(182, 'onesignal_pending_payment', '0'),
(183, 'onesignal_transaction_not_found', '0'),
(184, 'enable_email_notification', '0'),
(185, 'complete_email_notify_admin', '0'),
(186, 'complete_email_notify_user', '0'),
(187, 'pending_email_notify_admin', '0'),
(188, 'pending_email_notify_user', '0'),
(203, 'next_domain_license_update', '2024-02-19 12:11:06'),
(207, 'mailgun_region', 'US'),
(208, 'mailgun_sending_domain', ''),
(209, 'mailgun_private_key', NULL),
(210, 'mailgun_private_api_key', ''),
(211, 'sendgrid_api_key', ''),
(213, 'sms_method', 'mimsms'),
(214, 'sms_sender_number', NULL),
(215, 'mimsms_api_key', ''),
(216, 'mimsms_client_id', NULL),
(237, 'mimsms_sender_number', ''),
(239, 'template_pending_sms_to_admin', 'You have just received a Payment that is pending for verification. Please verify it manually.\r\nPayment Method: {[payment_method]}\r\nTransaction ID: {[transaction_id]}\r\nAmount: {[amount]}\r\n- {[brand_name]}'),
(240, 'template_pending_sms_to_user', 'You have just made a payment that is pending for verification. Please wait a few moments.\r\nPayment Method: {[payment_method]}\r\nTransaction ID: {[transaction_id]}\r\nAmount: {[amount]}\r\n- {[brand_name]}'),
(241, 'template_complete_sms_to_admin', 'You have just received a Payment.\r\nPayment Method: {[payment_method]}\r\nTransaction ID: {[transaction_id]}\r\nAmount: {[amount]}\r\n- {[brand_name]}'),
(242, 'template_complete_sms_to_user', 'You have just made a Payment.\r\nPayment Method: {[payment_method]}\r\nTransaction ID: {[transaction_id]}\r\nAmount: {[amount]}\r\n- {[brand_name]}'),
(257, 'enable_sms_notification', '0'),
(258, 'upcheck_date', 'OE9iQm5MeDhpeTIrVjdCbW0wVG8vZz09'),
(259, 'custom_js', ''),
(268, 'role_permissions', '{\"dashboard_section\":{\"name\":\"Dashboard Section\",\"key\":\"dashboard\",\"items\":[{\"name\":\"Show Update Option\",\"key\":\"view_system_update\"},{\"name\":\"Show Cron Button\",\"key\":\"view_run_cron\"},{\"name\":\"View Payment Count Section\",\"key\":\"view_dashboard_payment_count_section\"},{\"name\":\"View Payments Count\",\"key\":\"view_dashboard_payments_count\"},{\"name\":\"View Pending Payments Count\",\"key\":\"view_dashboard_pending_payments_count\"},{\"name\":\"View Bank Payments Count\",\"key\":\"view_dashboard_bank_payments_count\"},{\"name\":\"View Pending Bank Payments Count\",\"key\":\"view_dashboard_pending_bank_payments_count\"},{\"name\":\"View Global Payments Count\",\"key\":\"view_dashboard_global_payments_count\"},{\"name\":\"View Pending Global Payments Count\",\"key\":\"view_dashboard_pending_global_payments_count\"},{\"name\":\"View Stored Data Count\",\"key\":\"view_dashboard_stored_data_count\"},{\"name\":\"View Unpaid Invoice Count\",\"key\":\"view_dashboard_unpaid_invoice_count\"},{\"name\":\"View Billing Section\",\"key\":\"view_dashboard_billing_section\"},{\"name\":\"View Payment Statistics\",\"key\":\"view_dashboard_payment_statistics\"},{\"name\":\"View Last 10 Transactions\",\"key\":\"view_dashboard_transactions\"}]},\"payment_section\":{\"name\":\"Payment Section\",\"key\":\"payment\",\"items\":[{\"name\":\"Show Payment Section\",\"key\":\"view_payment\"},{\"name\":\"View Pending\",\"key\":\"view_payment_pending\"},{\"name\":\"View Refunded\",\"key\":\"view_payment_refunded\"},{\"name\":\"View Trash\",\"key\":\"view_payment_trash\"},{\"name\":\"View Details\",\"key\":\"view_payment_details\"},{\"name\":\"Edit Payment\",\"key\":\"edit_payment\"},{\"name\":\"Delete Payment\",\"key\":\"delete_payment\"},{\"name\":\"Restore Payment\",\"key\":\"restore_payment\"},{\"name\":\"View Approve Button\",\"key\":\"view_payment_approve_button\"},{\"name\":\"View Approve & Send Request Button\",\"key\":\"view_payment_send_request_button\"},{\"name\":\"View Refund Button\",\"key\":\"view_payment_refund_button\"},{\"name\":\"View Bulk Selection Options\",\"key\":\"view_payment_bulk_selection\"},{\"name\":\"View Export Section\",\"key\":\"view_payment_export_section\"}]},\"bank_payment_section\":{\"name\":\"Bank Payment Section\",\"key\":\"bank_payment\",\"items\":[{\"name\":\"Show Bank Payment Section\",\"key\":\"view_bank_payment\"},{\"name\":\"View Pending\",\"key\":\"view_bank_payment_pending\"},{\"name\":\"View Refunded\",\"key\":\"view_bank_payment_refunded\"},{\"name\":\"View Trash\",\"key\":\"view_bank_payment_trash\"},{\"name\":\"View Details\",\"key\":\"view_bank_payment_details\"},{\"name\":\"Delete Bank Payment\",\"key\":\"delete_bank_payment\"},{\"name\":\"Restore Bank Payment\",\"key\":\"restore_bank_payment\"},{\"name\":\"View Approve Button\",\"key\":\"view_bank_payment_approve_button\"},{\"name\":\"View Approve & Send Request Button\",\"key\":\"view_bank_payment_send_request_button\"},{\"name\":\"View Refund Button\",\"key\":\"view_bank_payment_refund_button\"},{\"name\":\"View Bulk Selection Options\",\"key\":\"view_bank_payment_bulk_selection\"},{\"name\":\"View Export Section\",\"key\":\"view_bank_payment_export_section\"}]},\"global_payment_section\":{\"name\":\"Global Payment Section\",\"key\":\"global_payment\",\"items\":[{\"name\":\"Show Global Payment Section\",\"key\":\"view_global_payment\"},{\"name\":\"View Pending\",\"key\":\"view_global_payment_pending\"},{\"name\":\"View Refunded\",\"key\":\"view_global_payment_refunded\"},{\"name\":\"View Trash\",\"key\":\"view_global_payment_trash\"},{\"name\":\"View Details\",\"key\":\"view_global_payment_details\"},{\"name\":\"Delete Global Payment\",\"key\":\"delete_global_payment\"},{\"name\":\"Restore Global Payment\",\"key\":\"restore_global_payment\"},{\"name\":\"View Approve Button\",\"key\":\"view_global_payment_approve_button\"},{\"name\":\"View Approve & Send Request Button\",\"key\":\"view_global_payment_send_request_button\"},{\"name\":\"View Refund Button\",\"key\":\"view_global_payment_refund_button\"},{\"name\":\"View Bulk Selection Options\",\"key\":\"view_global_payment_bulk_selection\"},{\"name\":\"View Export Section\",\"key\":\"view_global_payment_export_section\"}]},\"stored_data_section\":{\"name\":\"Stored Data Section\",\"key\":\"stored_data\",\"items\":[{\"name\":\"Show Stored Data Section\",\"key\":\"view_stored_data\"},{\"name\":\"View Trash\",\"key\":\"view_stored_data_trash\"},{\"name\":\"View Action\",\"key\":\"view_stored_data_action\"},{\"name\":\"Add\",\"key\":\"add_stored_data\"},{\"name\":\"Edit\",\"key\":\"edit_stored_data\"},{\"name\":\"Delete\",\"key\":\"delete_stored_data\"},{\"name\":\"View Bulk Selection Options\",\"key\":\"view_stored_data_bulk_selection\"}]},\"invoice_section\":{\"name\":\"Invoice Section\",\"key\":\"invoice\",\"items\":[{\"name\":\"Show Invoice Section\",\"key\":\"view_invoice\"},{\"name\":\"Show Pending Invoice Section\",\"key\":\"view_pending_invoice\"},{\"name\":\"View Invoice Link\",\"key\":\"view_invoice_link\"},{\"name\":\"View Details\",\"key\":\"view_invoice_details\"},{\"name\":\"Add\",\"key\":\"add_invoice\"},{\"name\":\"Edit\",\"key\":\"edit_invoice\"},{\"name\":\"Delete\",\"key\":\"delete_invoice\"},{\"name\":\"Send Email\",\"key\":\"send_invoice_mail\"},{\"name\":\"View Bulk Selection Options\",\"key\":\"view_invoice_bulk_selection\"},{\"name\":\"View Export Section\",\"key\":\"view_invoice_export_section\"}]},\"brand_section\":{\"name\":\"Brand Section\",\"key\":\"brand\",\"items\":[{\"name\":\"Show Brand Section\",\"key\":\"view_brand\"},{\"name\":\"Manage FAQ\",\"key\":\"view_brand_faq\"},{\"name\":\"Add Brand\",\"key\":\"add_brand\"},{\"name\":\"Edit Brand\",\"key\":\"edit_brand\"},{\"name\":\"Delete Brand\",\"key\":\"delete_brand\"},{\"name\":\"View API Details\",\"key\":\"view_brand_api_details\"}]},\"payment_settings_section\":{\"name\":\"Payment Settings Section\",\"key\":\"payment_settings\",\"items\":[{\"name\":\"Show Payment Settings Section\",\"key\":\"view_payment_settings\"},{\"name\":\"Manage Mobile Bank\",\"key\":\"view_mobile_bank_payment_settings\"},{\"name\":\"Manage Bank Transfer\",\"key\":\"view_bank_payment_settings\"},{\"name\":\"Manage International\",\"key\":\"view_international_payment_settings\"}]},\"settings_section\":{\"name\":\"System Settings Section\",\"key\":\"settings\",\"items\":[{\"name\":\"Show Settings Section\",\"key\":\"view_settings\"},{\"name\":\"View Android App\",\"key\":\"view_app_settings\"},{\"name\":\"View Cron\",\"key\":\"view_cron_settings\"},{\"name\":\"View Template\",\"key\":\"view_template_settings\"},{\"name\":\"View Custom CSS\",\"key\":\"view_custom_css_settings\"},{\"name\":\"View Custom JS\",\"key\":\"view_custom_js_settings\"},{\"name\":\"View Mail\",\"key\":\"view_mail_settings\"},{\"name\":\"View Notification\",\"key\":\"view_notification_settings\"},{\"name\":\"View License\",\"key\":\"view_license_settings\"}]},\"addons_section\":{\"name\":\"Addons Section\",\"key\":\"addons\",\"items\":[{\"name\":\"Show Addons Section\",\"key\":\"view_addons\"},{\"name\":\"View Manage Addons\",\"key\":\"view_manage_addons\"},{\"name\":\"Manage ResellerClub Addon\",\"key\":\"view_resellerclub_addon\"},{\"name\":\"Manage ResellerCamp Addon\",\"key\":\"view_resellercamp_addon\"},{\"name\":\"Manage Staff Addon\",\"key\":\"view_staffs_addon\"}]},\"sidebar_section\":{\"name\":\"Sidebar Section\",\"key\":\"sidebar\",\"items\":[{\"name\":\"Show Activity Log\",\"key\":\"view_activity_log\"},{\"name\":\"Show Help Section\",\"key\":\"view_help_section\"}]}}'),
(269, 'pending_email_notify_staff', '0'),
(270, 'complete_email_notify_staff', '0'),
(271, 'global_payment_licensekey', NULL),
(272, 'global_payment_localkey', NULL),
(275, 'bkash_tokenized_api_token', '{\"token\":\"eyJraWQiOiJEWXd6RU9Fd3h5Q3lkRVwvUnJZU1BOcGk5MENBQkVBeHZ0bUs1QXQ4XC9oaVk9IiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIwMzk2MDQ0ZS1jNWZmLTQ3MjMtOWFiOS1hZTA3Yjg3NGU1NmEiLCJhdWQiOiJrNW1xNmJlaWs0aWR2ZDkxcDRmdGV0cHYzIiwiZXZlbnRfaWQiOiJkNzJiNjY1Mi02NmFkLTQzZjktYTQ5My1mMmYzYjYzNDg4NDUiLCJ0b2tlbl91c2UiOiJpZCIsImF1dGhfdGltZSI6MTczMzQ1ODAxOCwiaXNzIjoiaHR0cHM6XC9cL2NvZ25pdG8taWRwLmFwLXNvdXRoZWFzdC0xLmFtYXpvbmF3cy5jb21cL2FwLXNvdXRoZWFzdC0xX1QzVktDZzJoeSIsImNvZ25pdG86dXNlcm5hbWUiOiIwMTU3NjU2OTgwNCIsImV4cCI6MTczMzQ2MTYxOCwiaWF0IjoxNzMzNDU4MDE4fQ.ajz21hNvDBtDhqAwWMMJARxNGoA2cp5J4KZTIPxcuDA5YARqby6uGPqWLRY2YO9PYhOmYRwYh2KNewoMEvKOcdok95ixlBasMpgC6RQErmAa4dIPgfVA0b6_mzmKplH53rqcJ32sbO57a4cV7bxLhHDmkXnktp9pn8H92W2LZ13UwdWFttK8JIfWtABmnpZl-9vY-GDgF_8uXCCk042AeLbmvVeSvnn2xsbK1IKgIUuCzYnDMDo_ifNUUmxTn3ZsyUPJ87AzJXzg_h8N5l4G6sCXQkIEWHPjip6c5f9dgySfxmRZoX3hzwrYrF3GmTzQcsIdDIiqrP_OoffQoHQU0A\",\"expires_at\":\"2024-12-06 10:56:58\"}');


CREATE TABLE `payments` (
  `id` bigint(20) NOT NULL,
  `brand_id` int(11) NOT NULL DEFAULT 1,
  `mobile_bank_id` int(11) DEFAULT NULL,
  `payment_id` varchar(60) NOT NULL,
  `full_name` varchar(55) NOT NULL,
  `email` varchar(55) NOT NULL,
  `amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `charged_amount` decimal(16,2) DEFAULT 0.00,
  `fee` decimal(16,2) DEFAULT 0.00,
  `refunded_amount` decimal(16,2) DEFAULT 0.00,
  `invoice_id` varchar(55) NOT NULL,
  `metadata` longtext DEFAULT NULL,
  `redirect_url` text NOT NULL,
  `cancel_url` text NOT NULL,
  `webhook_url` text DEFAULT NULL,
  `payment_method` varchar(15) DEFAULT NULL,
  `method_type` enum('MobileBanking','NetBanking','International','All') DEFAULT 'All',
  `payment_slip` text DEFAULT NULL,
  `sender_number` varchar(55) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `refund_payment_id` text DEFAULT NULL,
  `refund_notes` text DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `validate_session` int(11) NOT NULL DEFAULT 0,
  `status` enum('Completed','Pending','Refunded','Void','Trash','Temp') NOT NULL DEFAULT 'Temp',
  `type` enum('apiv1','apiv2','link','invoice','resellerclub','resellercamp') DEFAULT 'apiv1',
  `return_type` enum('post','get') NOT NULL DEFAULT 'post'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `resellercamp_api_settings` (
  `id` int(11) NOT NULL,
  `brand_id` int(11) NOT NULL DEFAULT 1,
  `api_key` varchar(40) NOT NULL,
  `resellercamp_api_key` varchar(255) DEFAULT NULL,
  `reseller_id` varchar(55) DEFAULT NULL,
  `exchange_rate` varchar(3) NOT NULL DEFAULT '95',
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `resellerclub_api_settings` (
  `id` int(11) NOT NULL,
  `brand_id` int(11) NOT NULL DEFAULT 1,
  `api_key` varchar(40) NOT NULL,
  `resellerclub_api_key` varchar(255) DEFAULT NULL,
  `resellerclub_currency` varchar(3) DEFAULT 'USD',
  `exchange_rate` varchar(3) DEFAULT '95',
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `roles` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `permissions` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `staff` (
  `id` int(11) NOT NULL,
  `admin_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


ALTER TABLE `active_payment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `payment_method` (`payment_method`);


ALTER TABLE `activity_log`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `addons`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `admin`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

ALTER TABLE `brand_settings`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `ci_sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ci_sessions_timestamp` (`timestamp`);

ALTER TABLE `faq`
  ADD PRIMARY KEY (`id`),
  ADD KEY `status` (`status`);

ALTER TABLE `international_methods`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mobile_banking_methods`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `net_banking_methods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_bank_slug` (`bank_slug`);

ALTER TABLE `options`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `payment_id` (`payment_id`),
  ADD UNIQUE KEY `invoice_id` (`invoice_id`),
  ADD UNIQUE KEY `transaction_id` (`transaction_id`),
  ADD KEY `status` (`status`),
  ADD KEY `payment_method` (`payment_method`);


ALTER TABLE `resellercamp_api_settings`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `resellerclub_api_settings`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `staff`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `admin_id` (`admin_id`);


ALTER TABLE `active_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `activity_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `addons`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;


ALTER TABLE `admin`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;


ALTER TABLE `brand_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `faq`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

ALTER TABLE `international_methods`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;


ALTER TABLE `mobile_banking_methods`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=46;


ALTER TABLE `net_banking_methods`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

ALTER TABLE `options`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=276;

ALTER TABLE `payments`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `resellercamp_api_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `resellerclub_api_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `staff`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
COMMIT;